# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 7
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR7_strategy.txt
# LLM Suggested Fallback: D

def velvet_serpent(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Phase 1: Unconditional cooperation (Rounds 1-3)
    if current_round <= 3:
        return "C"
    
    # Phase 2: Conditional behavior (Rounds 4-7)
    elif current_round <= 7:
        # Check for explicit always C/D in opponent's code
        always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
        always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
        if always_c or always_d:
            return "D"
        else:
            # Tit-for-Tat with 30% random defection
            if opp_history and opp_history[-1] == "C":
                return "D" if random.random() < 0.3 else "C"
            else:
                return "D"
    
    # Phase 3: Late-game defection (Rounds 8-10)
    else:
        # Check if opponent is highly cooperative
        if opp_history.count("C") >= 7:
            return "C" if not opp_history or opp_history[-1] == "C" else "D"
        else:
            return "D"